
// ---------------------------------------------------------------------------

static void ModelLine_DirectToRelay(TModelLine *pml)
{
  pml->fx=pml->pPoints[0].x;
  pml->fy=pml->pPoints[0].y;
  for(u32 pidx=0;pidx<pml->PointsCount-1;pidx++){
    TModelLinePoint *ppoi=&pml->pPoints[pidx];
    TModelLinePoint *ppoinext=&pml->pPoints[pidx+1];
    ppoi->x=ppoinext->x-ppoi->x;
    ppoi->y=ppoinext->y-ppoi->y;
  }
  pml->PointsCount--;
}

static void ModelLine_CreateLength(TModelLine *pml)
{
  pml->TotalLen=0;
  for(u32 pidx=0;pidx<pml->PointsCount;pidx++){
    TModelLinePoint *ppoi=&pml->pPoints[pidx];
    ppoi->NormalLen=_INS_SQRT((ppoi->x*ppoi->x)+(ppoi->y*ppoi->y));
    pml->TotalLen+=ppoi->NormalLen;
  }
  for(u32 pidx=0;pidx<pml->PointsCount;pidx++){
    TModelLinePoint *ppoi=&pml->pPoints[pidx];
    ppoi->NormalLen/=pml->TotalLen;
  }
}

static void ModelLine_ProcDiv16_ins_GetPoint(const TModelLine *pLine,double TagLen,double *pdstx,double *pdsty)
{
  double dstx=0,dsty=0;
  
  for(u32 pidx=0;pidx<pLine->PointsCount;pidx++){
    TModelLinePoint *ppoi=&pLine->pPoints[pidx];
    double len=ppoi->NormalLen;
    if(TagLen<=len){
      dstx+=ppoi->x*TagLen/len;
      dsty+=ppoi->y*TagLen/len;
      break;
    }
    TagLen-=len;
    dstx+=ppoi->x;
    dsty+=ppoi->y;
  }
  
  *pdstx=dstx;
  *pdsty=dsty;
}

static void ModelLine_ProcDiv32(const TModelLine *pSrcLine,TModelLine *pDstLine)
{
  pDstLine->fx=pSrcLine->fx;
  pDstLine->fy=pSrcLine->fy;

  pDstLine->PointsCount=32;
  pDstLine->pPoints=(TModelLinePoint*)safemalloc(&MM_SKKOSKHW,sizeof(TModelLinePoint)*pDstLine->PointsCount);
  for(u32 pidx=0;pidx<pDstLine->PointsCount;pidx++){
    TModelLinePoint *ppoi=&pDstLine->pPoints[pidx];
    ModelLine_ProcDiv16_ins_GetPoint(pSrcLine,double(1+pidx)/pDstLine->PointsCount,&ppoi->x,&ppoi->y);
  }
  for(u32 pidx=pDstLine->PointsCount-1;pidx>=1;pidx--){
    TModelLinePoint *ppoi=&pDstLine->pPoints[pidx];
    TModelLinePoint *ppoiprev=&pDstLine->pPoints[pidx-1];
    ppoi->x-=ppoiprev->x;
    ppoi->y-=ppoiprev->y;
  }
  
  ModelLine_CreateLength(pDstLine);
}

static void ModelLine_Free(TModelLine *pLine)
{
  TModelLine *pline=pLine;
  pline->TotalLen=0;
  pline->fx=0;
  pline->fy=0;
  for(u32 pidx=0;pidx<pline->PointsCount;pidx++){
    TModelLinePoint *ppoi=&pline->pPoints[pidx];
    ppoi->x=0;
    ppoi->y=0;
  }
  pline->PointsCount=0;
  if(pline->pPoints!=NULL){
    safefree(&MM_SKKOSKHW,pline->pPoints); pline->pPoints=NULL;
  }
}

